function out = trendfcast(trend,fcasthorizon,trendlt,decay) ;
%
%
%
%

if (nargin<2); fcasthorizon = 1; end ;
if (nargin<3); trendlt = trend; end ;
if (nargin<4); decay = .981; end ; % half-life of 3 years

[T,k] = size(trend) ;

trend(T+1:T+fcasthorizon,:) = repmat(NaN,fcasthorizon,k) ;
for i=1:k ;
  T1 = find(~isnan(trend(:,i))); T1 = T1(end) ;
  delt = trend(T1,i) - trend(T1-1,i) ;
  trend(T1+1:T+fcasthorizon,i) = trend(T1,i) + [1:T+fcasthorizon-T1]*delt ;
  ltdelt = trendlt(T1,i) - trendlt(T1-1,i) ;
  trendlt(T1+1:T+fcasthorizon,i) = trendlt(T1,i) + [1:T+fcasthorizon-T1]*ltdelt ;
  decaywts = decay .^ [1:T+fcasthorizon-T1]' ; % half-life of 3 years
  trend(T1+1:T+fcasthorizon,i) = decaywts .* trend(T1+1:T+fcasthorizon,i) + ...
                                (1-decaywts) .* trendlt(T1+1:T+fcasthorizon,i) ;
end ;

if (isempty(trend));
  out = repmat(NaN,T+fcasthorizon,0);
else; 
  out = trend ;
end ;


